
import API from '@/api/workbench'

// actions
export default {
    // 获取公告列表
    getNoticeList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getNoticeList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取公告详情列表数据
    getNoticeDetail ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getNoticeDetailList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取报修工单列表
    getOrderList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getOrderList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取设备列表数据
    getMachineList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getMachineList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取当前登录的客户信息
    getUserList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getUserList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
