import Cookies from 'js-cookie'
import API from '@/api/view'
import { MessageBox, Message } from 'element-ui'

// actions
export default {
    // 获取当前用户可查询的资源列表
    getResourceList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getResourceList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取某用户所拥有的角色列表
    getUserRoleList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getUserRoleList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取某用户所拥有的数据权限
    getDataPermissionList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getDataPermissionList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取某个用户的用户组列表数据
    geDepartmentLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.geDepartmentLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取数据权限部门列表数据
    getDataDepartment ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getDataDepartment(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
};
