import API from '@/api/role';
import {Message} from 'element-ui';

// actions
export default {
    /*----------角色----------*/
    // 查询所有角色信息
    getRoleList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getRoleList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增角色信息
    addRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    //修改角色信息
    editRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.editRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除角色
    deleteRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*----------角色结束----------*/
    /*----------角色-成员----------*/
    // 获取用户树
    getUserTreeList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getUserTreeList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据角色ID获取用户列表
    getUserListByRoleId ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getUserListByRoleId(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 批量删除角色下的用户
    batchDeleteMemberByRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.batchDeleteMemberByRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给角色添加用户列表
    addUserListForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addUserListForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*----------角色-成员结束----------*/
    /*----------角色-数据权限----------*/
    // 获取数据权限树
    getDataAuthTreeList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDataAuthTreeList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取角色拥有的权限列表
    getDataPermissionListForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDataPermissionListForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 批量删除角色拥有的数据权限列表
    batchDeleteDataAuthorityForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.batchDeleteDataAuthorityForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给角色添加数据权限列表
    addDataAuthorityListForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addDataAuthorityListForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*----------角色-数据权限结束----------*/
    /*----------角色-成员组----------*/
    // 获取用户组树
    getUserGroupTreeList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getUserGroupTreeList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取角色对应的用户组列表
    getUserGroupListByRoleId ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getUserGroupListByRoleId(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 批量删除角色下的用户组
    batchDeleteUserGroupListForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.batchDeleteUserGroupListForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给角色添加用户组列表
    addUserGroupListForRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addUserGroupListForRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*----------角色-成员组结束----------*/
    /*----------角色-功能权限----------*/
    // 获取角色对应的功能权限
    getRoleFeatures ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getRoleFeatures(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 角色管理 功能权限提交接口
    submitFeatures ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.submitFeatures(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
    /*----------角色-功能权限结束----------*/
};
