import API from '@/api/process'
import {Message} from 'element-ui'

export default {
    /*---------------------------------工艺路线-----------------------------------*/
    // 新增工艺
    addProcess ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addProcess(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工艺列表数据
    getProcessList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProcessList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑工艺路线
    updateProcess ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateProcess(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工艺路线
    deleteProcess ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteProcess(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据ID请求工艺路线数据
    getIdProcessList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getIdProcessList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工艺路线审批
    processCheck ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.processCheck(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 版本升级
    routingUpgrade ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.routingUpgrade(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 复制工艺路线
    copyProcess ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.copyProcess(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 切换工艺路线生效状态
    changeProcessStatus ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.changeProcessStatus(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },

    // 工艺路线关联物料
    addProcessMateriel ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addProcessMateriel(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工艺路线关联物料
    deleteProcessMateriel ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteProcessMateriel(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据产线id获取它的工艺路线
    getListByProductionLineId ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getListByProductionLineId(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------工序管理-----------------------------------*/
    // 获取工序列表数据
    getCraftsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getCraftsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工序
    addCrafts ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addCrafts(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工序
    deleteCrafts ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteCrafts(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑工序
    updateCrafts ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateCrafts(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工序排序
    sortCrafts ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.sortCrafts(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据ID获取工序详情数据
    getIdCraftsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getIdCraftsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取前道工序列表数据
    getFrontCraftsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getFrontCraftsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*-------------------------------获取工步列表数据-------------------------------------------*/
    // 获取工步列表数据
    getStepList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工步
    addStep ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStep(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工步
    deleteStep ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStep(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑工步
    updateStep ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateStep(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工步排序
    workStepSort ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.workStepSort(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取前道工步数据
    getFrontStepList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getFrontStepList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据ID获取工步数据
    getStepIdList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepIdList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据工步ID 查询工步关联物料
    getStepAssociateMaterielList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepAssociateMaterielList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工步关联物料
    addStepMateriel ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStepMateriel(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    //删除工步关联的物料
    deleteStepMateriel ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStepMateriel(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据工步ID查询质检工艺
    getStepQualityCrafts ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepQualityCrafts(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工步关联质检
    addStepInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStepInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工步关联质检
    deleteStepInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStepInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工步关联设备列表数据
    getStepAssociateDeviceList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepAssociateDeviceList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工步关联设备
    deleteStepDevice ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStepDevice(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工步关联设备
    addStepDevice ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStepDevice(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工步关联程序
    getStepAssociateProgramList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepAssociateProgramList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工步关联程序
    deleteStepProgram ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStepProgram(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工步关联程序
    addStepProgram ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStepProgram(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------质检工艺-----------------------------------*/
    // 获取质检工艺列表
    getInspectionList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getInspectionList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增质检工艺
    addInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 更新质检工艺
    updateInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除质检工艺
    deleteInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取一个质检工艺详情
    getInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 添加质检工艺检验项
    addQualityCraftsItem ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addQualityCraftsItem(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑质检工艺检验项
    editQualityCraftsItem ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.editQualityCraftsItem(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除质检工艺检验项
    deleteQualityCraftsItem ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteQualityCraftsItem(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 升级质检工艺
    inspectionUpgrade ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.inspectionUpgrade(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 复制质检工艺
    copyInspection ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.copyInspection(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 切换质检工艺生效状态
    changeInspectionStatus ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.changeInspectionStatus(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据工步ID分页查询所有未关联的质检工艺
    getStepQualityCraftsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStepQualityCraftsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*-----------------------------------------BOM管理页面--------------------------------*/
    // 获取BOM列表数据
    getBomList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getBomList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增BOM
    addBom ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addBom(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑BOM
    updateBom ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateBom(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除BOM
    deleteBom ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteBom(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据ID查询BOM数据
    findByIdBom ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.findByIdBom(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // bom版本升级
    bomUpgrade ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.bomUpgrade(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 复制BOM
    copyBom ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.copyBom(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 切换BOM生效状态
    changeBomStatus ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.changeBomStatus(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 通过BOM ID请求BOM节点getByBomIdNode
    getByBomIdNodeList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getByBomIdNodeList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增BOM节点
    addBomNode ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addBomNode(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑BOM节点
    editBomNode ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.editBomNode(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除BOM节点
    deleteBomNode ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteBomNode(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*-----------------------------------------程序管理---------------------------------------*/
    // 获取所有未关联工步的程序
    getStepUnassociatedProgramList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getStepUnassociatedProgramList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取程序列表数据
    getProgramList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getProgramList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增程序
    addProgram ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addProgram(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 编辑程序
    updateProgram ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateProgram(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除程序
    deleteProgram ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteProgram(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据程序ID获取程序详情数据
    getProgramDetailsList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getProgramDetailsList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据程序ID获取附件详情数据
    getProgramIdAnnexList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getProgramIdAnnexList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    //  // 韩国测试机程序下发
    sendKoreaTesterProgram ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.sendKoreaTesterProgram(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*-----------------------------------------------异构数据------------------------------------*/
    // 根据Id获取异构数据 程序
    getIsomerousList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getIsomerousList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据code获取异构数据 程序
    getIsomerousListData ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getIsomerousListData(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // NDF程序新增
    ndfInsert ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.ndfInsert(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // NDF程序修改
    ndfUpdate ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.ndfUpdate(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // NDR程序新增
    ndrInsert ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.ndrInsert(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // NDR程序修改
    ndrUpdate ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.ndrUpdate(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
}
