import API from '@/api/plan'
import {Message} from 'element-ui'

export default {
    /*---------------------------------计划管理-----------------------------------*/
    // 获取计划列表
    getPlanList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getPlanList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取计划详情列表
    getPlanDetailList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getPlanDetailList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增计划
    addPlan ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addPlan(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑计划
    editPlan ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.editPlan(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除计划
    delPlan ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.delPlan(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除计划
    delPlanDetail ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.delPlanDetail(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 修改计划详情
    updatePlanDetail ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updatePlanDetail(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*------------------------------计划拆分-------------------------------*/
    // 计划手动拆分
    handSplitPlan ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.handSplitPlan(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 计划手动拆分
    sendPlanDetail ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.sendPlanDetail(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
