import Cookies from 'js-cookie'
import API from '@/api/kanban'
import { MessageBox, Message } from 'element-ui'

// actions
export default {
    // 获取设备列表
    getEquipmentList ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取监控页面列表
    getMonitoringPageList ({dispatch, commit, state, rootState}) {
        return new Promise((resolve, reject) => {
            API.getMonitoringPageList().then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 更新监控页面列表
    updateMonitoringPageByKanban ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateMonitoringPageByKanban(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
