import API from '@/api/management';
import {
    Message
} from 'element-ui';

export default {
    /*———————————————————————————————————————— App 管理 ————————————————————————————————————————*/
    // !新增App
    addAppManagement ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.addAppManagement(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // !获取App列表数据
    getAppManagementList ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.getAppManagementList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // !编辑App
    updateAppManagement ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateAppManagement(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // !删除App
    deleteAppManagement ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteAppManagement(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },

    /**———————————————————————————————————————— App版本管理 ————————————————————————————————————————**/
    /**
     * ! 新增App版本表单
     */
    addAppExamine ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.addAppExamine(queryParams).then(response => {
                if (response.code === 600) {
                    console.log(response.data)
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /**
     * ! 新增App版本程序包
     */
    addAppExamineFile ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.addAppExamineFile(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                console.log(error)
                reject(error)
            })
        });
    },
    /**
     * !获取App版本列表数据
     */
    getAppExamineList ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.getAppExamineList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /**
     * !编辑App版本
     */
    updateAppExamine ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateAppExamine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /**
     * !删除App版本
     */
    deleteAppExamine ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteAppExamine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /**
     * !下载App版本
     */
    downloadAppVersion ({
        commit,
        state
    }, queryParams) {
        return new Promise((resolve, reject) => {
            API.downloadAppVersion(queryParams).then(response => {
                resolve(response)
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
