import Mock from 'mockjs';

const allDepartment = {
    code: 600,
    message: 'SUCCESS',
    data: [{
        id: 'ROOT',
        name: '某某某信息集团',
        parentId: null,
        parentName: null,
        parent: {id: null, name: null},
        roles: ['ROLE_USER'],
        children: [{
            id: 'A1',
            name: 'A1',
            parent: {id: 'ROOT', name: '某某某信息集团'},
            roles: ['ROLE_USER', 'ROLE_ADMIN'],
            children: [{
                id: 'A1-1',
                name: 'A1-1',
                parent: {id: 'A1', name: 'A1'},
                children: [{
                    id: 'A1-1-1',
                    name: 'A1-1-1',
                    parent: {id: 'A1-1', name: 'A1-1'}
                }]
            },
            {
                id: 'A1-2',
                name: 'A1-2',
                parent: {id: 'A1', name: 'A1'}
            }]
        },
        {
            id: 'A2',
            name: 'A2',
            parent: {id: 'ROOT', name: '某某某信息集团'},
            roles: ['ROLE_USER'],
            children: [{
                id: 'A2-1',
                name: 'A2-1',
                parent: {id: 'A2', name: 'A2'}
            }]
        },
        {
            id: 'A3',
            name: 'A2',
            parent: {id: 'ROOT', name: '某某某信息集团'},
            roles: ['ROLE_USER'],
            children: [{
                id: 'A2-1',
                name: 'A2-1',
                parent: {id: 'A2', name: 'A2'}
            }]
        },
        {
            id: 'A4',
            name: 'A2',
            parent: {id: 'ROOT', name: '某某某信息集团'},
            roles: ['ROLE_USER'],
            children: [{
                id: 'A2-1',
                name: 'A2-1',
                parent: {id: 'A2', name: 'A2'}
            }]
        },
        {
            id: 'A5',
            name: 'A2',
            parent: {id: 'ROOT', name: '某某某信息集团'},
            roles: ['ROLE_USER'],
            children: [{
                id: 'A2-1',
                name: 'A2-1',
                parent: {id: 'A2', name: 'A2'}
            }]
        }]
    }]
}

let subDepartment = {'code': 600, 'message': 'SUCCESS', 'data': []};
function tabularAllDepartment (departmentList, id) {
    departmentList.forEach((item, index) => {
        if (item.id === id) {
            subDepartment.data = item.children;
        } else {
            // 还有子级，再次递归
            if (item.children !== undefined && item.children !== null && item.children.length > 0) {
                tabularAllDepartment(item.children, id)
            }
        }
    })
}


let subMember = {'code': 600, 'message': 'SUCCESS', 'data': []};
function returnMemberList (id) {
    let list = [];
    for (let i = 0; i < 15; i++) {
        if (i % 2 === 0) {
            list.push({
                id: i,
                username: '员工' + i,
                name: 'haha' + i,
                weChat: 'haha' + i,
                roles: ['ROLE_USER', 'ROLE_ADMIN'],
                groups: [
                    getDepartmentNameById(id),
                    {
                        id: 'A2-1',
                        name: 'A2-1'
                    }
                ]
            })
        } else {
            list.push({
                id: i,
                username: '员工' + i,
                name: 'haha' + i,
                weChat: 'haha' + i,
                roles: ['ROLE_USER'],
                groups: [getDepartmentNameById(id)]
            })
        }
    }
    subMember.data = list;
}

// 拍扁部门层级，转变为一层（供列表显示name查询使用）
let tabularAllDepartmentList1 = [];
function tabularAllDepartment1 (departmentList) {
    departmentList.forEach((item, index) => {
        tabularAllDepartmentList1.push({id: item.id, name: item.name})
        // 还有子级，再次递归
        if (item.children !== undefined && item.children !== null && item.children.length > 0) {
            tabularAllDepartment1(item.children)
        }
    })
}

function getDepartmentNameById (id) {
    let obj = {};
    for (let i = 0, len = tabularAllDepartmentList1.length; i < len; i++) {
        if (tabularAllDepartmentList1[i].id === id) {
            obj = tabularAllDepartmentList1[i];
            break;
        }
    }
    return obj
}



// 拦截接口
// 当跟后台联调真实数据时，直接注释掉对应接口的拦截就可以了
Mock.mock(/\/api\/v1\/group\/list/, 'post', config => {
    return allDepartment
});
Mock.mock(/\/api\/group\/listGroup/, 'post', config => {
    subDepartment = {'code': 600, 'message': 'SUCCESS', 'data': []};
    tabularAllDepartment(allDepartment.data, JSON.parse(config.body).groupId)
    return subDepartment
});
Mock.mock(/\/api\/group\/user\/find/, 'post', config => {
    subMember = {'code': 600, 'message': 'SUCCESS', 'data': []};
    tabularAllDepartmentList1 = []
    tabularAllDepartment1(allDepartment.data)
    returnMemberList(JSON.parse(config.body).id)
    return subMember
});

export default Mock;
