import request from '@/utils/request'

export default {
    loginByUsername (param) {
        const data = {
            username: param.username,
            password: param.password
        }
        return request({
            url: `${process.env.API_HOST}/auth/login`,
            method: 'post',
            data: data
        })
    },
    getUserInfo () {
        return request({
            url: `${process.env.API_HOST}/api/v1/user`,
            method: 'get',
            data: {}
        })
    },
    getUserAuthority () {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/resource/list`,
            method: 'get',
            data: {}
        })
    },
    updateUserInfo (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user`,
            method: 'put',
            data: {
                newName: param.newName,
                newPassword: param.newPassword,
                oldPassword: param.oldPassword
            }
        })
    },
    logout () {
        return request({
            url: '/login/logout',
            method: 'post'
        })
    },
    // 获取管理责任人
    getResponsibleList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v1/group/${queryParams.groupId}/user/list`,
            method: 'get',
            data
        })
    },
    // 获取用户组列表
    geDepartmentLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v1/group/tree`,
            method: 'get',
            data
        })
    }
}
