import request from '@/utils/request'

export default {
    // 1.获取设备档案列表
    getEquipmentDocumentList (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/page`,
            method: 'get',
            data: queryParams
        })
    },
    // 2.根据id获取设备主要数据
    getEquipmentMainById (param) {
        const data = {
            equipId: param.id
        }
        return request({
            url: `${process.env.API_HOST}/api/equipment/listEquipmentDetails`,
            method: 'get',
            data
        })
    },
    // 3.获取设备实时信息数据
    getEquipmentActualTimeData (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/equipmentData/findEquipmentData`,
            method: 'get',
            data: queryParams
        })
    },
    // 4.获取设备历史信息
    getEquipmentHistoryInformationData (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/equipmentData/findHistoryData`,
            method: 'get',
            data: queryParams
        })
    },
    // 5.获取设备维修信息
    getRepairInformationData (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/equipmentData/findEquipmentRepair`,
            method: 'get',
            data: queryParams
        })
    },
    // 6.获取设备历史生产数据
    getEquipmentHistoryProduceData (equipmentId) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/equipmentData/findHistoryProduce?equipId=${equipmentId}`,
            method: 'get'
        })
    },
    // 7.获取设备报警信息
    getEquipmentWarningInformation (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/equipmentData/findSystemWarning`,
            method: 'get',
            data: queryParams
        })
    },
    // 8.设备档案新建
    equipmentCreate (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/create`,
            method: 'post',
            data: queryParams
        })
    },
    // 9.设备档案编辑
    equipmentEdit (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/update`,
            method: 'put',
            data: queryParams
        })
    },
    // 10.删除设备档案
    equipmentDelete (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/delete`,
            method: 'delete',
            data: queryParams
        })
    },
    // 11.图片删除
    pictureDelete (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/equipment/deleteFile`,
            method: 'post',
            data: queryParams
        })
    },
    // 12.获取设备分类列表
    getEquipmentTypeListData (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/list`,
            method: 'get',
            data
        })
    },
    // 13.根据父级id查询子类型
    getGenreListDataByParentId (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/listByParent`,
            method: 'get',
            data
        })
    },
    // 14.新增设备类型
    createEquipmentGenre (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/create`,
            method: 'post',
            data
        })
    },
    // 15.删除设备类型
    deleteEquipmentGenre (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/delete`,
            method: 'delete',
            data
        })
    },
    // 16.编辑设备类别
    editEquipmentGenre (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/update`,
            method: 'put',
            data
        })
    }
}
