// 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
// hidden: true // (默认 false)

// 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
// 只有一个时，会将那个子路由当做根路由显示在侧边栏--如引导页面
// 若你想不管路由下面的 children 声明的个数都显示你的根路由
// 你可以设置 alwaysShow: true，这样它就会忽略之前定义的规则，一直显示根路由
// alwaysShow: true

import Vue from 'vue'
import Router from 'vue-router'

/* Router Modules */
// 欢迎
import welcomeRouter from './modules/welcome'
// 车间（设备数据）
import workshopRouter from './modules/workshop'
// 设备运行时间
import deviceRunningTimeRouter from './modules/deviceRunning'
// 基础数据
import basicRouter from './modules/basic'
// 系统管理
import systemRouter from './modules/system'

Vue.use(Router)

// 框架级路由
export const constantRouterMap = [{
    path: '/',
    name: 'Login',
    component: () => import('@/views/Login'),
    hidden: true
},
{
    path: '/404',
    component: () => import('@/views/ErrorPage/404'),
    hidden: true
},
{
    path: '/401',
    component: () => import('@/views/ErrorPage/401'),
    hidden: true
}]

// 业务级路由（后期可能在界面中动态配置）
export const asyncRouterMap = [
    welcomeRouter,
    workshopRouter,
    deviceRunningTimeRouter,
    basicRouter,
    systemRouter,
    {
        path: '*',
        redirect: '/404',
        hidden: true
    }
]

export default new Router({
    // mode: 'history', // require service support
    scrollBehavior: () => ({
        y: 0
    }),
    routes: constantRouterMap
})
