import request from '@/utils/request'

export default {
    /*----------角色----------*/
    // 查询所有角色信息
    getRoleList (param) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/v1/role/list`,
            method: 'GET',
            data
        })
    },
    // 新增角色信息
    addRole (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role`,
            method: 'POST',
            data
        })
    },
    // 修改角色信息
    editRole (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role`,
            method: 'PUT',
            data
        })
    },
    // 删除角色
    deleteRole (param) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}`,
            method: 'DELETE',
            data
        })
    },
    /*----------角色----------*/
    /*----------角色-成员----------*/
    // 获取用户树
    getUserTreeList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/group/tree/user`,
            method: 'GET',
            data
        })
    },
    // 根据角色ID获取用户列表
    getUserListByRoleId (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/userList`,
            method: 'GET',
            data
        })
    },
    // 批量删除角色下的用户
    batchDeleteMemberByRole (param) {
        const data = param.userIdList;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/roleUser`,
            method: 'DELETE',
            data
        })
    },
    // 给角色添加用户列表
    addUserListForRole (param) {
        const data = param.userIdList;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/users`,
            method: 'PUT',
            data
        })
    },
    /*----------角色-成员结束----------*/
    /*----------角色-数据权限----------*/
    // 获取数据权限树
    getDataAuthTreeList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/group/tree/dataAuth`,
            method: 'GET',
            data
        })
    },
    // 获取角色拥有的权限列表
    getDataPermissionListForRole (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/dataList`,
            method: 'GET',
            data
        })
    },
    // 批量删除角色拥有的数据权限列表
    batchDeleteDataAuthorityForRole (param) {
        const data = param.dataAuthorityIdList;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/deleteData`,
            method: 'DELETE',
            data
        })
    },
    // 给角色添加数据权限列表
    addDataAuthorityListForRole (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/dataPermission`,
            method: 'PUT',
            data
        })
    },
    /*----------角色-数据权限结束----------*/
    /*----------角色-成员组----------*/
    // 获取用户组树
    getUserGroupTreeList (param) {
        const data = {};
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/group/tree`,
            method: 'GET',
            data
        })
    },
    // 获取角色对应的用户组列表
    getUserGroupListByRoleId (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/groupList`,
            method: 'GET',
            data
        })
    },
    // 批量删除角色下的用户组
    batchDeleteUserGroupListForRole (param) {
        const data = param.groupList;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/roleGroup`,
            method: 'DELETE',
            data
        })
    },
    // 给角色添加用户组列表
    addUserGroupListForRole (param) {
        const data = param.groupList;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/groups`,
            method: 'PUT',
            data
        })
    },
    /*----------角色-成员组结束----------*/
    /*----------角色-功能权限----------*/
    // 获取角色对应的功能权限
    getRoleFeatures (param) {
        const data = param.resourceId;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/resources`,
            method: 'GET',
            data
        })
    },
    // 角色管理 功能权限提交接口
    submitFeatures (param) {
        const data = param.resourceId;
        return request({
            url: `${process.env.API_HOST}/api/v1/role/${param.roleId}/resource`,
            method: 'PUT',
            data
        })
    }
    /*----------角色-功能权限结束----------*/
}
