import API from '@/api/document'
import {Message} from 'element-ui'

export default {
    // 1.获取设备档案列表
    getEquipmentDocumentList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentDocumentList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 2.根据id获取设备主要数据
    getEquipmentMainById ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getEquipmentMainById(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 3.获取设备实时信息数据
    getEquipmentActualTimeData ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentActualTimeData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 4.获取设备历史信息
    getEquipmentHistoryInformationData ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentHistoryInformationData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 5.获取设备维修信息
    getRepairInformationData ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getRepairInformationData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 6.获取设备历史生产数据
    getEquipmentHistoryProduceData ({commit, state}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getEquipmentHistoryProduceData(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 7.获取设备报警信息
    getEquipmentWarningInformation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentWarningInformation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 8.设备档案新建
    equipmentCreate ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.equipmentCreate(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 9.设备档案编辑
    equipmentEdit ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.equipmentEdit(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 10.删除设备档案
    equipmentDelete ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.equipmentDelete(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 11.图片删除
    pictureDelete ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.pictureDelete(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 12.获取设备分类列表
    getEquipmentTypeListData ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getEquipmentTypeListData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 13.根据父级id查询子类型
    getGenreListDataByParentId ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getGenreListDataByParentId(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 14.新增设备类型
    createEquipmentGenre ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.createEquipmentGenre(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 15.删除设备类型
    deleteEquipmentGenre ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteEquipmentGenre(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 16.编辑设备类别
    editEquipmentGenre ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.editEquipmentGenre(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        });
    }
}
