/**
 * 系统管理路由
 */
export default {
    path: '/system',
    component: () => import('@/views/Layout'),
    redirect: '/system/user',
    meta: {title: 'System', icon: 'setting'},
    alwaysShow: true,
    children: [
        {
            path: 'user',
            component: () => import('@/views/System/user'),
            name: 'User',
            meta: {title: 'User', icon: 'user', noCache: false, mark: '/system/user'}
        },
        {
            path: 'role',
            component: () => import('@/views/System/Role/role'),
            name: 'Role',
            meta: {title: 'Role', icon: 'role', noCache: false, mark: '/system/role'}
        },
        {
            path: 'dict',
            component: () => import('@/views/System/dict'),
            name: 'Dict',
            meta: {title: 'Dict', icon: 'role', noCache: false, mark: '/system/dict'}
        },
        {
            path: 'userView/:id(\\d+)',
            component: () => import('@/views/System/userView'),
            name: 'UserView',
            meta: { title: 'UserView', icon: 'role', noCache: false },
            hidden: true  // 人员详情视图不在菜单显示
        }
    ]
}
