// 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
// hidden: true // (默认 false)

// 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
// 只有一个时，会将那个子路由当做根路由显示在侧边栏--如引导页面
// 若你想不管路由下面的 children 声明的个数都显示你的根路由
// 你可以设置 alwaysShow: true，这样它就会忽略之前定义的规则，一直显示根路由
// alwaysShow: true

import Vue from 'vue'
import Router from 'vue-router'

/* Router Modules */
// 欢迎
import welcomeRouter from './modules/welcome'
// 车间（设备数据）
import workshopRouter from './modules/workshop'
// 设备运行时间
import deviceRunningTimeRouter from './modules/deviceRunning'
// 基础数据
import basicRouter from './modules/basic'
// 化验室报告
import laboratoryRouter from './modules/laboratory'
// 烘干室温度
import dryingRoomChartRouter from './modules/dryingRoomChart'
// 涂装生产计划
import productionPlanRouter from './modules/productionPlan'
// AVI大屏
import monitorRouter from './modules/monitor'
// 监控大屏
import centerControl from './modules/centerControll'
// 系统管理
import systemRouter from './modules/system'

Vue.use(Router)

// 框架级路由
export const constantRouterMap = [{
    path: '/',
    name: 'Login',
    component: () => import('@/views/Login'),
    hidden: true
},
{
    path: '/404',
    component: () => import('@/views/ErrorPage/404'),
    hidden: true
},
{
    path: '/401',
    component: () => import('@/views/ErrorPage/401'),
    hidden: true
},
// pc avi 轮播
{
    path: '/carouselAvi',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/carouselAvi/index',
    meta: { title: 'CarouselAvi', icon: 'template', openNewWindow: true },
    hidden: true,
    children: [
        {
            path: 'index',
            component: () => import('@/views/Monitor/CarouselAvi/index'),
            name: 'CarouselAviIndex',
            meta: { title: 'CarouselAviIndex', icon: 'template' }
        }
    ]
},
// led
{
    path: '/led',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/led/stationOne',
    meta: { title: 'Led', icon: 'template', openNewWindow: true },
    hidden: true,
    children: [
        {
            // 工位屏1
            path: 'stationOne',
            component: () => import('@/views/Led/Station/stationOne'),
            name: 'StationOne',
            meta: { title: 'StationOne', icon: 'template' }
        },
        {
            // 工位屏2
            path: 'stationTwo',
            component: () => import('@/views/Led/Station/stationTwo'),
            name: 'StationTwo',
            meta: { title: 'StationTwo', icon: 'template' }
        },
        {
            // 工位屏3
            path: 'stationThree',
            component: () => import('@/views/Led/Station/stationThree'),
            name: 'StationThree',
            meta: { title: 'StationThree', icon: 'template' }
        },
        {
            // 工位屏4
            path: 'stationFour',
            component: () => import('@/views/Led/Station/stationFour'),
            name: 'StationFour',
            meta: { title: 'StationFour', icon: 'template' }
        },
        {
            // 工位屏5
            path: 'stationFive',
            component: () => import('@/views/Led/Station/stationFive'),
            name: 'StationFive',
            meta: { title: 'StationFive', icon: 'template' }
        },
        {
            // 工位屏6
            path: 'stationSix',
            component: () => import('@/views/Led/Station/stationSix'),
            name: 'StationSix',
            meta: { title: 'StationSix', icon: 'template' }
        },
        {
            // 工位屏7
            path: 'stationSeven',
            component: () => import('@/views/Led/Station/stationSeven'),
            name: 'StationSeven',
            meta: { title: 'StationSeven', icon: 'template' }
        },
        {
            //涂装车间
            path: 'workShopPaintingWorkShop',
            component: () => import('@/views/Led/WorkShop/paintingWorkShop'),
            name: 'WorkShopPaintingWorkShop',
            meta: { title: 'WorkShopPaintingWorkShop', icon: 'template' }
        },
        {
            // voc
            path: 'stationVoc',
            component: () => import('@/views/Led/Station/voc'),
            name: 'StationVoc',
            meta: { title: 'StationVoc', icon: 'template' }
        }
    ]
},
// led avi 轮播
{
    path: '/ledCarouselAvi',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/ledCarouselAvi/index',
    meta: { title: 'LedCarouselAvi', icon: 'kanban', openNewWindow: true },
    hidden: true,
    children: [
        {
            path: 'index',
            component: () => import('@/views/LedCarouselAvi/index'),
            name: 'LedCarouselAviIndex',
            meta: { title: 'LedCarouselAviIndex', icon: 'kanban' }
        }
    ]
}]

// 业务级路由（后期可能在界面中动态配置）
export const asyncRouterMap = [
    welcomeRouter,
    workshopRouter,
    deviceRunningTimeRouter,
    basicRouter,
    laboratoryRouter,
    dryingRoomChartRouter,
    productionPlanRouter,
    monitorRouter,
    centerControl,
    systemRouter,
    {
        path: '*',
        redirect: '/404',
        hidden: true
    }
]

export default new Router({
    // mode: 'history', // require service support
    scrollBehavior: () => ({
        y: 0
    }),
    routes: constantRouterMap
})
