import API from '@/api/dict'
import {Message} from 'element-ui'
// actions
export default {
    // 获取字典项列表
    getDictList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDictList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 分页查询字典信息
    getDictItemList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDictItemList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据ID获取字典项
    getDictDetailList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getDictDetailList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新建字典项
    addDictItem ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addDictItem(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 编辑字典项
    updateDictItem ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateDictItem(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 启用或停用字典项
    offOrOnDictItem ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.offOrOnDictItem(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 通过字典ID得到字典项
    getItemListByDictId ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getItemListByDictId(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取某一字典的条目列表
    getEntryList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getEntryList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增条目
    addEntry ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addEntry(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 修改条目
    updateEntry ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateEntry(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 条目停用 启用
    enableEntry ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.enableEntry(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据字典code获取字典条目
    getCodeEntryList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getCodeEntryList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
