import request from '@/utils/request'

export default {
    // 获取资源列表
    getResourceList () {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/v1/resource/menu/list`,
            method: 'get',
            data
        })
    },
    // 根据角色获取资源列表
    getResourceListByRole (param) {
        const data = {
            roleCode: param.roleCode
        }
        return request({
            url: `${process.env.API_HOST}/api/v1/resource/menu/role/${param.roleCode}`,
            method: 'get',
            data
        })
    },
    // 根据用户获取此用户的资源列表
    getResourceListByUser (param) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/v1/resource/menu/user/list`,
            method: 'get',
            data
        })
    },
    // 添加一个资源
    addResource (param) {
        const data = {
            name: param.name,
            type: param.type,
            url: param.url,
            parentId: param.parentId,
            children: param.children
        }
        return request({
            url: `${process.env.API_HOST}/api/v1/resource`,
            method: 'post',
            data
        })
    },
    // 更新一个资源
    updateResource (param) {
        const data = {
            id: param.id,
            name: param.name,
            type: param.type,
            url: param.url,
            parentId: param.parentId,
            children: param.children,
            createTime: param.createTime
        }
        return request({
            url: `${process.env.API_HOST}/api/v1/resource`,
            method: 'put',
            data
        })
    },
    // 删除一个资源
    deleteResource (param) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/v1/resource/${param.id}`,
            method: 'delete',
            data
        })
    }
}
