import customerApi from '@/api/customer';
import {Message} from 'element-ui';

// actions
export default {
    // 1.获取客户详细信息数据
    getCustomerInfo ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            customerApi.getCustomerInfo(reqData).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 2.获取客户列表数据
    getCustomerListData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            customerApi.getCustomerListData(reqData).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
