import caseApi from '@/api/case'
import {Message} from 'element-ui';

// actions
export default {
    // 1.获取工程案例详情
    getProjectCaseDetails ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            caseApi.getProjectCaseDetails(reqData).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 2.获取工程案例列表页数据
    getProjectCaseListData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            caseApi.getProjectCaseListData(reqData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};

