import request from '@/utils/request'

export default {
    // 获取字典项列表
    getDictList (param) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/dict/getDictList`,
            method: 'get',
            data
        })
    },
    // 分页查询字典信息
    getDictItemList (param) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/page?pageNum=${param.pageNum}&pageSize=${param.pageSize}&like=${param.like}&code=${param.code}`,
            method: 'get',
            data
        })
    },
    // 根据ID获取字典项
    getDictDetailList (param) {
        const data = param
        return request({
            url: `${process.env.API_HOST}/api/dict/getItemListByDictId`,
            method: 'get',
            data
        })
    },
    // 新建字典项
    addDictItem (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict`,
            method: 'post',
            data
        })
    },
    // 编辑字典项
    updateDictItem (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict`,
            method: 'put',
            data
        })
    },
    // 启用或停用字典项
    offOrOnDictItem (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/enable?enable=${param.enable}&id=${param.id}`,
            method: 'put',
            data
        })
    },
    // 通过字典ID得到字典项
    getItemListByDictId (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/dict/getItemListByDictId`,
            method: 'get',
            data
        })
    },
    // 获取某一字典的条目列表
    getEntryList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/item/page`,
            method: 'get',
            data
        })
    },
    // 新增条目
    addEntry (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/item`,
            method: 'post',
            data
        })
    },
    // 修改条目
    updateEntry (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/item`,
            method: 'PUT',
            data
        })
    },
    // 条目停用 启用
    enableEntry (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/item/enable?enable=${param.enable}&id=${param.id}`,
            method: 'PUT',
            data
        })
    },
    // 根据字典编码获取字典条目
    getCodeEntryList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/v2/dict/item/dicItem/${param.dicCode}`,
            method: 'get',
            data
        })
    }
}
