/**
 * Author by Oliver, Email Oliver_web@163.com, Date on 2019/4/23.
 * 将公共JS进行挂在到全局
 *
 */

// const install = function () {
//     Object.keys(common).forEach(key => {
//         Vue.prototype['$' + key] = common[key];
//     })
// }
import Vue from 'vue'
import moment from 'moment'
import fetch from './fetch'

/**
 * 等待执行
 * @param time 传入时间
 * @returns {Promise<any>}
 */
let sleep = time => new Promise(resolve => {
    setTimeout(resolve, time)
})

/**
 * 用于表单默认恢复初始值,将对象中属性值进行清空
 * @param initObject 需要清空对象
 * @returns {*}
 */
function clearObject (initObject) {
    Object.keys(initObject).forEach((key) => {
        initObject[key] = ''
    })
    return initObject
}

/**
 * 判断数组对象中每个值不能为空
 * @param data 数组对象
 * @returns {boolean}
 */
function isEmpty (data) {
    if (!data || data.length === 0) return true
    for (let v of data) {
        for (let item of Object.keys(v)) {
            if (v[item] === '') {
                return true
            }
        }
    }
    return false
}

const install = function () {
    Vue.prototype.$sleep = sleep
    Vue.prototype.$clearObject = clearObject
    Vue.prototype.$isEmpty = isEmpty
    Vue.prototype.$moment = moment
    Vue.prototype.$fetch = fetch
}
export default install
