import API from '@/api/resource'

// actions
export default {
    // 获取全部资源列表
    getResourceList ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getResourceList(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据角色获取资源列表
    getResourceListByRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getResourceListByRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 根据用户获取此用户的资源列表
    getResourceListByUser ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getResourceListByUser(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 添加一个资源
    addResource ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addResource(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 更新一个资源
    updateResource ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateResource(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除一个资源
    deleteResource ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteResource(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
