import API from '@/api/materials'
import {Message} from 'element-ui'

export default {
    /*---------------------------------物料分类数据-----------------------------------*/
    // 查询物料分类左侧树形菜单
    getMaterialsTypeList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getMaterialsTypeList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据物料分类ID 请求物料列表数据
    getTypeIdMaterialsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getTypeIdMaterialsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取所有的物料列表数据
    getMaterialsList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getMaterialsList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取车间 产线 工位属性数据
    getByProLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getByProLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工步关联物料列表数据
    getProcessStepMaterielList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProcessStepMaterielList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据工艺路线ID获取物料列表数据
    getProcessIdMaterielList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProcessIdMaterielList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增物料
    addMaterial ({ commit, state }, queryParams) {
        return new Promise((resolve, reject) => {
            API.addMaterial(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 修改物料
    updateMaterial ({ commit, state }, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateMaterial(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除物料
    delMaterial ({ commit, state }, queryParams) {
        return new Promise((resolve, reject) => {
            API.delMaterial(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },

    /*---------------------------------物料属性数据-----------------------------------*/
    // 获取物料属性列表
    getMaterialPropertyList ({ commit, state }, queryParams) {
        return new Promise((resolve, reject) => {
            API.getMaterialPropertyList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    //  新增物料属性
    addMaterialPropert ({ commit, state }, queryParams) {
        return new Promise((resolve, reject) => {
            API.addMaterialPropert(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
