import Mock from 'mockjs';

const allResource = {'code': 600, 'message': 'SUCCESS', 'data': [{'id': 3, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '维修管理', 'type': 'MENU', 'url': '/maintain/list', 'parentId': null, 'children': [{'id': 6, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增维修记录', 'type': 'BUTTON', 'url': 'ADD', 'parentId': 3, 'children': null}]}, {'id': 4, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增刀具', 'type': 'MENU', 'url': '/cutter/new', 'parentId': null, 'children': [{'id': 7, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增刀具功能', 'type': 'BUTTON', 'url': 'ADD', 'parentId': 4, 'children': null}]}, {'id': 5, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '刀具列表', 'type': 'MENU', 'url': '/cutter/list', 'parentId': null, 'children': []}]}

const roleResource = {'code': 600, 'message': 'SUCCESS', 'data': [{'id': 3, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '维修管理', 'type': 'MENU', 'url': '/maintain/list', 'parentId': null, 'children': [{'id': 6, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增维修记录', 'type': 'BUTTON', 'url': 'ADD', 'parentId': 3, 'children': null}]}, {'id': 4, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增刀具', 'type': 'MENU', 'url': '/cutter/new', 'parentId': null, 'children': [{'id': 7, 'createTime': '2018-10-26T16: 00: 00.000+0000', 'name': '新增刀具功能', 'type': 'BUTTON', 'url': 'ADD', 'parentId': 4, 'children': null}]}]}

// 拦截接口
// 当跟后台联调真实数据时，直接注释掉对应接口的拦截就可以了
Mock.mock(/\/api\/resource\/menu\/list/, 'get', config => {
    return allResource
});
Mock.mock(/\/api\/resource\/menu\/role\/*/, 'get', config => {
    if (JSON.parse(config.body).roleCode === 'ROLE_ROOT') {
        return roleResource
    } else {
        return {'code': 600, 'message': 'SUCCESS', 'data': []}
    }
});
Mock.mock(/\/api\/resource/, 'post', config => {
    return {'code': 600, 'message': 'SUCCESS', 'data': []}
});
Mock.mock(/\/api\/resource/, 'put', config => {
    return {'code': 600, 'message': 'SUCCESS', 'data': []}
});
Mock.mock(/\/api\/resource/, 'delete', config => {
    return {'code': 600, 'message': 'SUCCESS', 'data': []}
});

export default Mock;
