// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import lodash from 'lodash';
import 'babel-polyfill'

import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import './styles/index.scss' // global css
import App from './App'
import router from './router'
import store from './store';

import i18n from './lang' // Internationalization
import './assets/icons' // icon
import './assets/fonts/font.scss' // font
import './permission' // permission control
import prototypeJS from './utils/prototypeJS/index' // 挂载公共JS方法
import formValidator from '@/utils/formValidator/index';
// import './mock' // mock
// 开发环境下使用mock，其他环境使用真实数据
// if (process.env.NODE_ENV === 'development') { require('./mock') }  // mock

import Authority from '../src/utils/authority';
import vueSwiper from 'vue-awesome-swiper'
import 'swiper/dist/css/swiper.css'  //引入样式
Vue.prototype._ = lodash;
Vue.prototype.formValidator = formValidator;
Vue.config.productionTip = false
Vue.prototype.Authority = Authority;
Vue.use(ElementUI, {
    size: 'medium', // set element-ui default size
    i18n: (key, value) => i18n.t(key, value)
})

Vue.use(prototypeJS)

/* eslint-disable no-new */
new Vue({
    el: '#app',
    router,
    store,
    i18n,
    vueSwiper,
    render: h => h(App)
})

