/**
 *  车间（设备数据）路由
 */
export default {
    path: '/workshop',
    component: () => import('@/views/Layout'),
    redirect: '/workshop/parts',
    meta: { title: 'Workshop', icon: 'dict' },
    alwaysShow: true,
    children: [
        {
            path: 'parts',
            component: () => import('@/views/Workshop/Parts/list'),
            name: 'Parts',
            meta: { title: 'Parts', icon: 'wareHouse', noCache: false, mark: '/workshop/parts/list' }
        },
        {
            path: 'welding',
            component: () => import('@/views/Workshop/Welding/list'),
            name: 'Welding',
            meta: { title: 'Welding', icon: 'wareHouse', noCache: false, mark: '/workshop/welding/list' }
        },
        {
            path: 'painting',
            component: () => import('@/views/Workshop/Painting/list'),
            name: 'Painting',
            meta: { title: 'Painting', icon: 'wareHouse', noCache: false, mark: '/workshop/painting/list' }
        },
        {
            path: 'chassis',
            component: () => import('@/views/Workshop/Chassis/list'),
            name: 'Chassis',
            meta: { title: 'Chassis', icon: 'wareHouse', noCache: false, mark: '/workshop/chassis/list' }
        },
        {
            path: 'final',
            component: () => import('@/views/Workshop/Final/list'),
            name: 'Final',
            meta: { title: 'Final', icon: 'wareHouse', noCache: false, mark: '/workshop/final/list' }
        },
        {
            path: 'trial',
            component: () => import('@/views/Workshop/Trial/list'),
            name: 'Trial',
            meta: { title: 'Trial', icon: 'wareHouse', noCache: false,  mark: '/workshop/trial/list' }
        },
        {
            path: 'quality',
            component: () => import('@/views/WorkShop/Quality/list'),
            name: 'Quality',
            meta: { title: 'Quality', icon: 'wareHouse', noCache: false, mark: '/workshop/quality/list' }
        },
        {
            path: 'other',
            component: () => import('@/views/WorkShop/Other/list'),
            name: 'Other',
            meta: { title: 'Other', icon: 'wareHouse', noCache: false, mark: '/workshop/other/list' }
        }
    ]
}
