import request from '@/utils/request';

export default {
    /*---------------------------------产线数据-----------------------------------*/
    // 获取产线下面的工位
    getStationList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/listLines`,
            method: 'get',
            data
        })
    },
    // 获取产线列表数据
    getProductionLineList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/listLines`,
            method: 'get',
            data
        })
    },
    // 新增产线
    addProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/createLine`,
            method: 'post',
            data
        })
    },
    // 编辑产线
    updateProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/updateLine`,
            method: 'post',
            data
        })
    },
    // 删除产线
    deleteProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/deleteLine`,
            method: 'delete',
            data
        })
    },
    // 根据ID查询产线详情
    findById (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/findById`,
            method: 'get',
            data
        })
    },
    // 停用 启用产线
    enableProductionLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/productionLine/status`,
            method: 'put',
            data
        })
    }
}
