import API from '@/api/department'

// actions
export default {
    // 获取所有部门列表
    getAllDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getAllDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取子部门列表
    getSubDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getSubDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增一个部门
    addDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 更新一个部门
    updateDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除一个部门
    deleteDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给部门调整角色
    adjustDepartmentRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.adjustDepartmentRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取一个部门的成员
    getSubMember ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getSubMember(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 新增一个成员
    addMember ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.addMember(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 更新一个成员
    updateMember ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.updateMember(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 删除成员
    deleteMember ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.deleteMember(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 重置一个成员密码
    resetMemberPassword ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.resetMemberPassword(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给成员调整部门
    adjustMemberDepartment ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.adjustMemberDepartment(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 给成员调整角色
    adjustMemberRole ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.adjustMemberRole(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
