/**
 * Created by zhangyan on 17/11/1.
 */
import Vue from 'vue';
import Vuex from 'vuex';
import middlewares from './middlewares';
import createLogger from 'vuex/dist/logger';

import state from './state'
import getters from './getters'
import mutations from './mutations'
import actions from './actions'


/**
 * 引入业务页面模块
 */
// 框架级页面所使用到的
import User from './modules/User';
import Department from './modules/Department';
import Role from './modules/Role';
import Resource from './modules/Resource';
import Dict from './modules/Dict';
import Permission from './modules/Permission';
import TabsView from './modules/TabsView';
// 业务级页面所使用到的
// 设备分类及设备台帐
import Equipment from './modules/Equipment';
// 大屏监控
import Monitoring from './modules/Monitoring';
// 工作台页面
import Workbench from './modules/Workbench';
// 基础信息
import Basic from './modules/Basic';
// 产能管理
import Capacity from './modules/Capacity';
// 物料管理
import Materials from './modules/Materials';
// 工艺路线
import Process from './modules/Process';
// 过程管理
import Course from './modules/Course';
// 计划管理
import Plan from './modules/Plan';
// 日历配置
import Calendar from './modules/Calendar';
// 人员信息视图
import UserView from './modules/UserView';
// App 管理
import AppManagement from './modules/AppManagement'
// 看板管理
import Kanban from './modules/Kanban'
/**
 * 使用vuex
 */
Vue.use(Vuex);

const debug = process.env.NODE_ENV !== 'production';
Vue.config.debug = debug;

export default new Vuex.Store({
    state,
    getters,
    mutations,
    actions,
    modules: {
        User,
        Department,
        Role,
        Resource,
        Dict,
        Permission,
        TabsView,
        Equipment,
        Monitoring,
        Workbench,
        Basic,
        Plan,
        Capacity,
        UserView,
        Materials,
        Process,
        Course,
        Calendar,
        AppManagement,
        Kanban
    },
    strict: debug,
    middlewares: middlewares,
    plugins: [createLogger()]
});
