// 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
// hidden: true // (默认 false)

// 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
// 只有一个时，会将那个子路由当做根路由显示在侧边栏--如引导页面
// 若你想不管路由下面的 children 声明的个数都显示你的根路由
// 你可以设置 alwaysShow: true，这样它就会忽略之前定义的规则，一直显示根路由
// alwaysShow: true

import Vue from 'vue'
import Router from 'vue-router'

/* Router Modules */
// 欢迎
import welcomeRouter from './modules/welcome'
// 车间（设备数据）
import workshopRouter from './modules/workshop'
// 设备运行时间
import deviceRunningTimeRouter from './modules/deviceRunning'
// 基础数据
import basicRouter from './modules/basic'
// 化验室报告
import laboratoryRouter from './modules/laboratory'
// 涂装生产计划
import productionPlanRouter from './modules/productionPlan'
// AVI大屏
import monitorRouter from './modules/monitor'
// 监控大屏
import centerControl from './modules/centerControll'
// 系统管理
import systemRouter from './modules/system'

Vue.use(Router)

// 框架级路由
export const constantRouterMap = [{
    path: '/',
    name: 'Login',
    component: () => import('@/views/Login'),
    hidden: true
},
{
    path: '/404',
    component: () => import('@/views/ErrorPage/404'),
    hidden: true
},
{
    path: '/401',
    component: () => import('@/views/ErrorPage/401'),
    hidden: true
},
// pc avi 轮播
{
    path: '/carouselAvi',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/carouselAvi/index',
    meta: { title: 'CarouselAvi', icon: 'template', openNewWindow: true },
    hidden: true,
    children: [
        {
            path: 'index',
            component: () => import('@/views/Monitor/CarouselAvi/index'),
            name: 'CarouselAviIndex',
            meta: { title: 'CarouselAviIndex', icon: 'template' }
        }
    ]
},
// led
{
    path: '/led',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/led/stationElectrophoresis',
    meta: { title: 'Led', icon: 'template', openNewWindow: true },
    hidden: true,
    children: [
        {
            //电泳
            path: 'stationElectrophoresis',
            component: () => import('@/views/Led/Station/electrophoresis'),
            name: 'StationElectrophoresis',
            meta: { title: 'StationElectrophoresis', icon: 'template' }
        },
        {
            //隔热防腐
            path: 'stationInsulatingAnticorrosive',
            component: () => import('@/views/Led/Station/insulatingAnticorrosive'),
            name: 'StationInsulatingAnticorrosive',
            meta: { title: 'stationInsulatingAnticorrosive', icon: 'template' }
        },
        {
            //腻子
            path: 'stationPutty',
            component: () => import('@/views/Led/Station/putty'),
            name: 'StationPutty',
            meta: { title: 'StationPutty', icon: 'template' }
        },
        {
            //中涂人工
            path: 'stationApplyArtificial',
            component: () => import('@/views/Led/Station/applyArtificial'),
            name: 'StationApplyArtificial',
            meta: { title: 'StationApplyArtificial', icon: 'template' }
        },
        {
            //中涂机器人
            path: 'stationFloatingCoatRobot',
            component: () => import('@/views/Led/Station/floatingCoatRobot'),
            name: 'StationFloatingCoatRobot',
            meta: { title: 'StationFloatingCoatRobot', icon: 'template' }
        },
        {
            //面/清漆
            path: 'stationSurfaceVarnish',
            component: () => import('@/views/Led/Station/surfaceVarnish'),
            name: 'StationSurfaceVarnish',
            meta: { title: 'StationSurfaceVarnish', icon: 'template' }
        },
        {
            //喷漆室，烘干室
            path: 'stationSprayDryingRoom',
            component: () => import('@/views/Led/Station/sprayDryingRoom'),
            name: 'StationSprayDryingRoom',
            meta: { title: 'StationSprayDryingRoom', icon: 'template' }
        },
        {
            //涂装车间
            path: 'workShopPaintingWorkShop',
            component: () => import('@/views/Led/WorkShop/paintingWorkShop'),
            name: 'WorkShopPaintingWorkShop',
            meta: { title: 'WorkShopPaintingWorkShop', icon: 'template' }
        },
        {
            // voc
            path: 'stationVoc',
            component: () => import('@/views/Led/Station/voc'),
            name: 'StationVoc',
            meta: { title: 'StationVoc', icon: 'template' }
        }
    ]
},
// led avi 轮播
{
    path: '/ledCarouselAvi',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/ledCarouselAvi/index',
    meta: { title: 'LedCarouselAvi', icon: 'kanban', openNewWindow: true },
    hidden: true,
    children: [
        {
            path: 'index',
            component: () => import('@/views/LedCarouselAvi/index'),
            name: 'LedCarouselAviIndex',
            meta: { title: 'LedCarouselAviIndex', icon: 'kanban' }
        }
    ]
}]

// 业务级路由（后期可能在界面中动态配置）
export const asyncRouterMap = [
    welcomeRouter,
    workshopRouter,
    deviceRunningTimeRouter,
    basicRouter,
    laboratoryRouter,
    productionPlanRouter,
    monitorRouter,
    centerControl,
    systemRouter,
    {
        path: '*',
        redirect: '/404',
        hidden: true
    }
]

export default new Router({
    // mode: 'history', // require service support
    scrollBehavior: () => ({
        y: 0
    }),
    routes: constantRouterMap
})
