import request from '@/utils/request';

export default {
    /*---------------------------------物料数据-----------------------------------*/
    // 查询物料分类树形菜单
    getMaterialsTypeList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materielType/tree`,
            method: 'get',
            data
        })
    },
    // 根据物料分类ID 请求物料列表数据
    getTypeIdMaterialsList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/getBytypeId`,
            method: 'get',
            data
        })
    },
    // 获取所有的物料列表数据
    getMaterialsList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/page`,
            method: 'get',
            data
        })
    },
    // 获取车间 产线 工位属性数据
    getByProLine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v2/workshop/tree`,
            method: 'get',
            data
        })
    },
    // 获取工步关联物料列表数据
    getProcessStepMaterielList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepMateriel/page`,
            method: 'get',
            data
        })
    },
    // 根据工艺路线ID获取物料数据
    getProcessIdMaterielList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/getByCraftsRouteId/${queryParams.craftsRouteId}`,
            method: 'get',
            data
        })
    },
    // 新增物料
    addMaterial (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/create`,
            method: 'post',
            data
        })
    },
    // 修改物料
    updateMaterial (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/update`,
            method: 'put',
            data
        })
    },
    // 删除物料
    delMaterial (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materiel/delete/${queryParams.id}`,
            method: 'delete',
            data
        })
    },

    //物料属性
    // 获取物料属性列表
    getMaterialPropertyList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materielProperty/getByMaterielId/${queryParams.materielId}`,
            method: 'get',
            data
        })
    },
    // 新增物料属性
    addMaterialPropert (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/materielProperty/create`,
            method: 'post',
            data
        })
    }
}
