/*
* 日历配置
* */
import request from '@/utils/request'

export default {
    // 新增星期配置
    addCalendarWeekConfig (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/add/common/config`,
            method: 'post',
            data: queryParams
        })
    },
    // 获取星期配置
    getCalendarWeekConfig (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/common/config`,
            method: 'post',
            data: {...queryParams}
        })
    },
    // 修改星期配置数据
    updateCalendarWeekConfig (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/update/common/config`,
            method: 'get',
            data: {...param}
        })
    },
    // 设置周配置生效和实效的配置
    updateCalendarWeekActive (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/common/config/active`,
            method: 'get',
            data: {...param}
        })
    },
    // 删除某一个时间段配置
    deleteCalendarPeriod (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/commonConfig/${param.commonConfigId}`,
            method: 'delete',
            data: {...param}
        })
    },
    // 获取精准日期
    getPreciseCalendar (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/precise/getWorkCalendar`,
            method: 'get',
            data: {...param}
        })
    },
    // 设置某一天是是工作日
    updateConfigType (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/commonConfig/day/configType`,
            method: 'get',
            data: {...param}
        })
    },
    // 修改精准配置
    updateCalendarPreciseConfig (param) {
        return request({
            url: `${process.env.API_HOST}/api/calendar/precise/updateCalendarPreciseConfig`,
            method: 'post',
            data: {...param}
        })
    }
}
