import Cookies from 'js-cookie'
import API from '@/api/user'
import { MessageBox, Message } from 'element-ui'

// actions
export default {
    // 登录系统
    loginByUsername ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.loginByUsername(queryParam).then(response => {
                if (response.code === 600) {
                    commit('SET_TOKEN', response.data.token);
                    window.sessionStorage.setItem('Admin-Token', response.data.token)
                    dispatch('getUserInfo').then((userInfo) => {
                        window.sessionStorage.setItem('Admin-Username', userInfo.username)
                        window.sessionStorage.setItem('Admin-Name', userInfo.name)
                        dispatch('getUserAuthority').then((authority) => {
                            window.sessionStorage.setItem('Admin-Authority', JSON.stringify(authority))
                            resolve(authority)
                        }).catch((error) => {
                            reject(error)
                        })
                    }).catch((error) => {
                        reject(error)
                    })
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取用户信息
    getUserInfo ({dispatch, commit, state, rootState}) {
        return new Promise((resolve, reject) => {
            API.getUserInfo().then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取用户权限数据
    getUserAuthority ({dispatch, commit, state, rootState}) {
        return new Promise((resolve, reject) => {
            API.getUserAuthority().then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 修改用户信息
    updateUserInfo ({dispatch, commit, state, rootState}, param) {
        return new Promise((resolve, reject) => {
            API.updateUserInfo(param).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    MessageBox.confirm(response.message, '错误提示', {
                        showCancelButton: false,
                        type: 'error'
                    });
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 设置多语言
    languageChange ({dispatch, commit, state, rootState}, language) {
        return new Promise((resolve, reject) => {
            commit('SET_LANGUAGE', language);
        });
    },
    // 获取管理责任列表
    getResponsibleList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getResponsibleList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取用户组列表
    geDepartmentLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.geDepartmentLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
};
