import request from '@/utils/request'
export default {
    /*———————————————————————————————————————— App 管理 ————————————————————————————————————————*/
    // !1. 新增App
    addAppManagement (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/create`,
            method: 'post',
            data
        })
    },
    // !2. 获取App列表数据
    getAppManagementList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/page`,
            method: 'get',
            data
        })
    },
    // !3. 编辑App
    updateAppManagement (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/updateAppInfo`,
            method: 'put',
            data
        })
    },
    // !4. 删除App
    deleteAppManagement (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/deleteAppByCode/${queryParams.id}`,
            method: 'delete',
            data
        })
    },

    /*———————————————————————————————————————— App版本管理 ————————————————————————————————————————*/

    // !1. 新增App程序包文件
    addAppExamine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/upload`,
            method: 'post',
            data
        })
    },
    // !新增App文件信息
    addAppExamineFile (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/uploadfile`,
            // url: `${process.env.API_HOST}/api/app/uploadfile?appCode=string&appRemarks=1111&appVersion=1.1.11&url=/Packages/1556257185150__UNI__153E840_0419172655.apk`,
            method: 'post',
            data
        })
    },
    // !2. 获取App版本列表数据
    getAppExamineList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/appVersionPage`,
            method: 'get',
            data
        })
    },
    // !3. 编辑App版本数据
    updateAppExamine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/updateAppVersion`,
            method: 'put',
            data
        })
    },
    // !4. 删除App版本
    deleteAppExamine (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/app/deleteAppVersion/${queryParams.id}`,
            method: 'delete',
            data
        })
    },
    // !4. 下载App版本
    downloadAppVersion (queryParams) {
        return request({
            url: `${process.env.API_HOST}/api/app/downLoad/${queryParams.id}`,
            method: 'get',
            responseType: 'blob'
        })
    }
}
