import request from '@/utils/request';

export default {
    /*---------------------------------工步关联设备模块-----------------------------------*/
    // 获取未关联工步的设备列表
    getStepUnassociatedDeviceList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/processStepEquipment/page`,
            method: 'get',
            data
        })
    },
    /*---------------------------------设备分类数据-----------------------------------*/
    // 获取设备分类列表
    getClassificationList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/list`,
            method: 'get',
            data
        })
    },
    // 获取设备分类 左侧树列表数据
    getTreeList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/listByParent`,
            method: 'get',
            data
        })
    },
    // 编辑设备分类 左侧树列表数据
    updateTree (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/updateParentType`,
            method: 'put',
            data
        })
    },
    // 新增设备分类 左侧树列表数据
    addTree (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/createParentType`,
            method: 'post',
            data
        })
    },
    // 删除设备分类 左侧树列表数据
    detailTree (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/deleteParentType?id=${queryParams.id}`,
            method: 'delete',
            data
        })
    },
    // 新增设备分类 列表数据
    addClassification (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/create`,
            method: 'post',
            data
        })
    },
    // 编辑设备分类 列表数据
    updateClassification (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/update`,
            method: 'put',
            data
        })
    },
    // 停用设备分类 列表数据
    disableEquipment (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/updateEquipTypeStatus`,
            method: 'put',
            data
        })
    },
    // 根据ID获取编辑列表数据
    getUpdateClassificationList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/findById`,
            method: 'get',
            data
        })
    },
    // 删除分类列表
    deleteClassificationList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/delete`,
            method: 'delete',
            data
        })
    },
    /*---------------------------------设备档案数据-----------------------------------*/
    // 获取分类视图数据
    getCategoryViewList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipmentType/typeView`,
            method: 'get',
            data
        })
    },
    // 获取部门视图数据
    getDepartmentViewList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/findEquipTypeView`,
            method: 'get',
            data
        })
    },
    // 获取设备档案 列表数据
    getArchivesList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/pageList`,
            method: 'get',
            data
        })
    },
    // 新增设备档案
    addArchives (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/create`,
            method: 'post',
            data
        })
    },
    // 删除设备档案
    deleteArchives (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/delete`,
            method: 'delete',
            data
        })
    },
    // 编辑设备档案
    updateArchives (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/update`,
            method: 'put',
            data
        })
    },
    // 请求新增档案时设备分类的数据
    getEquipmentTypeList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/typeList`,
            method: 'get',
            data
        })
    },
    //获取编辑时的档案详情
    getEditArchivesDetailList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipment/findById`,
            method: 'get',
            data
        })
    },
    /*---------------------------------设备投运数据-----------------------------------*/
    // 新设备投运
    newCommissioned (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipOperatingRecord/putEquipment`,
            method: 'put',
            data
        })
    },
    // 设备退运
    returnCommissioned (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/equipOperatingRecord/returnEquipment`,
            method: 'put',
            data
        })
    },
    // 设备报障
    equipmentReporting (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/repairReport/createReport`,
            method: 'post',
            data
        })
    }
}
