import publishApi from '@/api/publish'
import {Message} from 'element-ui'

export default {
    // 获取信息发布列表
    getPublishList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            publishApi.getPublishList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error)
            })
        });
    },
    // 新增信息发布
    addPublish ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            publishApi.addPublish(postData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message);
                    reject(resData);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 获取上报详情
    getPublishDetail ({commit, state}, queryParam) {
        return new Promise((resolve, reject) => {
            publishApi.getPublishDetail(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 停用或者启用信息发布
    stopOrPublish ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            publishApi.stopOrPublish(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error)
            })
        })
    }
}
