import API from '@/api/monitoring'
import { Message } from 'element-ui';

// actions
export default {
    // 1.获取烘箱数据
    getOvenData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getOvenData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 2.获取托盘数据
    getTray ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getTray(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 3.获取烘箱温度数据
    getOvenTemperature ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getOvenTemperature(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取封装线设备数据
    getPackageLine ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getPackageLine(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取运行设备列表数据
    getRunAmount ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getRunAmount(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取封装线异常设备列表
    getWarningEquipment ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getWarningEquipment(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取耐压数据
    getVoltageData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getVoltageData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取共面数据
    getCoplanarData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getCoplanarData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取复测数据
    getRetestData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getRetestData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message({
                        type: 'error',
                        message: `${resData.message}`
                    })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取韩国测试机数据
    getTestMachineData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getTestMachineData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    // Message({
                    //     type: 'error',
                    //     message: `${resData.message}`
                    // })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 综合面板
    getIntegrateData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getIntegrateData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    // Message({
                    //     type: 'error',
                    //     message: `${resData.message}`
                    // })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    //  // 实时温度数据(编带机、烘箱)
    getIntegrateTemperatureData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getIntegrateTemperatureData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    // Message({
                    //     type: 'error',
                    //     message: `${resData.message}`
                    // })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 获取当日温度统计数据
    getMachineTemperatureData ({dispatch, commit, state, rootState}, reqData) {
        return new Promise((resolve, reject) => {
            API.getMachineTemperatureData(reqData).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    // Message({
                    //     type: 'error',
                    //     message: `${resData.message}`
                    // })
                    reject(resData)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};
