import calendarApi from '@/api/calendar'
import { Message } from 'element-ui'

// actions
export default {
    // 新增星期配置
    addCalendarWeekConfig ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.addCalendarWeekConfig(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    reject(resData.message)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 获取星期配置
    getCalendarWeekConfig ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.getCalendarWeekConfig(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 修改星期配置的数据
    updateCalendarWeekConfig ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.updateCalendarWeekConfig(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    deleteCalendarPeriod ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.deleteCalendarPeriod(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 对本周进行激活.
    updateCalendarWeekActive ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.updateCalendarWeekActive(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 设置某天是否是工作日
    updateConfigType ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.updateConfigType(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    getPreciseCalendar ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.getPreciseCalendar(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 获取
    updateCalendarPreciseConfig ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            calendarApi.updateCalendarPreciseConfig(queryParams).then(resData => {
                if (resData.code === 600) {
                    resolve(resData.data)
                } else {
                    Message.error(resData.message)
                    reject(resData)
                }
            }).catch(error => {
                reject(error)
            })
        })
    }
}
