import API from '@/api/basic'
import {Message} from 'element-ui'

export default {
    /*---------------------------------车间管理-----------------------------------*/
    // 获取车间列表
    getWorkshopList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getWorkshopList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增车间
    addWorkshop ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addWorkshop(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑车间
    updateWorkshop ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateWorkshop(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除车间
    deleteWorkshop ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteWorkshop(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------产线管理-----------------------------------*/
    // 根据车间ID获取产线列表
    getProductionLineListById ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProductionLineListById(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取产线列表
    getProductionLineList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProductionLineList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增产线
    addProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑产线
    updateProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除产线
    deleteProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 产线取消关联的工位
    unlinkStation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.unlinkStation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据id获取产线详情数据
    getProductionLineById ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProductionLineById(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据车间选取产线树形数据
    getShopProductionLineList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getShopProductionLineList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*---------------------------------工位管理-----------------------------------*/
    // 根据产线id获取工位列表
    getStationListById ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationListById(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工位列表
    getStationList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工位详情
    getStationById ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationById(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取待选工位
    getNoSelectedList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getNoSelectedList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工位
    addStation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addStation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑工位
    updateStation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateStation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工位
    deleteStation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除产线工位关联关系
    delPositionRelation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.delPositionRelation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 关联工位
    relevanceStation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.relevanceStation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工位和设备的关联关系
    deleteStationDeviceRelation ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteStationDeviceRelation(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工位已关联的设备列表
    getStationAssociatedDevice ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationAssociatedDevice(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工位未关联的设备列表
    getStationNoAssociatedDevice ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationNoAssociatedDevice(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 工位关联设备
    stationRelevanceDevice ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.stationRelevanceDevice(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取工位对应的APP功能权限
    getAppFeatures ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.getAppFeatures(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 保存工位对应的APP功能权限
    saveAppFeatures ({dispatch, commit, state, rootState}, queryParam) {
        return new Promise((resolve, reject) => {
            API.saveAppFeatures(queryParam).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    /*-----------------------------------------托盘建档--------------------------------------------*/
    // 获取托盘列表数据
    getTrayList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getTrayList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增托盘
    addTray ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addTray(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑托盘
    updateTray ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateTray(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除托盘
    deleteTray ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteTray(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    /*-----------------------------------------工装夹具--------------------------------------------*/
    // 获取工装夹具列表数据
    getFixtureList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getFixtureList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增工装夹具
    addFixture ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addFixture(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑工装夹具
    updateFixture ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateFixture(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除工装夹具
    deleteFixture ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteFixture(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
