
# 业务组件 - 表格列配置

**此搜索组件是针对列表页面中用户可根据自己的使用习惯进行修改每列的顺序和是否显示的业务组件**
**需npm install来安装第三方组件vuedraggable（实现拖拽排序）**

主要功能有四部分组成
1. 列拖拽排序
2. 列点击隐藏或显示
3. 再次登录保留上次操作的列状态

### demo示例
[![](demo1.png)](demo1.png "markdown")


### demo代码

```html
### 注意：需要在float-right的div添加flex类，flex布局已进行封装
<TableColumnConfig
    :colList="tableConfig.fieldList"
    @change="tableColumnChange"
></TableColumnConfig>

```

```javascript
import TableColumnConfig from '../../components/TableColumnConfig'
export default {
    components: {
        TableColumnConfig
    },
    data () {
        return {
            // 表格配置项（其实组件只需要fieldList字段，为了使用方便，这里直接把tableConfig搞过来了）
            tableConfig: {
                height: 0,
                data: [],
                fieldList: [
                    { label: '表名', value: 'tableName' },
                    { label: '字段名', value: 'columnName' },
                    { label: '编码规则', value: 'barcodeConfig' },
                    { label: '最新编码', value: 'lastCode' },
                    { label: '创建人', value: 'createUser', width: '100', align: 'left' },
                    { label: '创建时间', value: 'createTime', type: 'time', dateFormate: 'YYYY-MM-DD HH:mm:ss', align: 'left' },
                    { label: '更新人', value: 'updateUser', width: '100', align: 'left' },
                    { label: '更新时间', value: 'updateTime', type: 'time', dateFormate: 'YYYY-MM-DD HH:mm:ss', align: 'left' }
                ],
                paginationToggle: true,
                paginationConfig: {
                    total: 0,
                    currentPage: 1,
                    pageSize: 20
                }
            }
        }
    }
    methods: {
        // 表格列 变化事件
        tableColumnChange (data) {
            this.tableConfig.fieldList = data
        }
    }
}
```

