import request from '@/utils/request'

export default {
    // 1.获取烘箱数据
    getOvenData (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/oven/getTemperatureAndStatus`,
            method: 'get',
            data
        })
    },
    // 2.获取托盘数据
    getTray (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/oven/getTrayData`,
            method: 'get',
            data
        })
    },
    // 3.获取烘箱温度数据
    getOvenTemperature (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/oven/getTemperatureData`,
            method: 'get',
            data
        })
    },
    // 获取封装线设备数据
    getPackageLine (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/packagingLine/getPackagingLineData`,
            method: 'get',
            data
        })
    },
    // 获取运行设备列表数据
    getRunAmount (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/packagingLine/getRunAmount`,
            method: 'get',
            data
        })
    },
    // 获取封装线异常设备列表数据
    getWarningEquipment () {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/monitor/packagingLine/getWarningEquipment`,
            method: 'get',
            data
        })
    },
    // 获取耐压数据
    getVoltageData (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/ferrite/voltageData`,
            method: 'get',
            data
        })
    },
    // 获取共面数据
    getCoplanarData (reqData) {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/ferrite/coplanarData`,
            method: 'get',
            data
        })
    },
    // 获取复测数据
    getRetestData () {
        const data = {}
        return request({
            url: `${process.env.API_HOST}/api/ferrite/retestData`,
            method: 'get',
            data
        })
    },
    // 获取韩国测试机数据
    getTestMachineData () {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = {}
        // API_SCADA
        return request({
            url: `${url}/api/datacenter/equip/koreaTester`,
            method: 'get',
            data
        })
    },
    // 综合面板
    getIntegrateData (queryParams) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = queryParams;
        // API_SCADA
        return request({
            url: `${url}/api/datacenter/equipStatus/equipType`,
            method: 'get',
            data
        })
    },
    // 实时温度数据(编带机、烘箱)
    getIntegrateTemperatureData (queryParams) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = queryParams;
        // API_SCADA
        return request({
            url: `${url}/api/datacenter/equipTemperature/equipType`,
            method: 'get',
            data
        })
    },
    // 根据设备类型，获取当日温度统计数据
    getMachineTemperatureData (queryParams) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = queryParams;
        // API_SCADA
        return request({
            url: `${url}/api/datacenter/equipTemperature/analysis/equipType`,
            method: 'get',
            data
        })
    }
}
