import saleApi from '@/api/sale'
import {Message} from 'element-ui'
export default {
    // 1.获取销售列表
    getSaleList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            saleApi.getSaleList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error)
            })
        })
    },
    // 2.新增销售合同
    saveAddSale ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            saleApi.saveAddSale(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 3.编辑销售合同
    saveEditSale ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            saleApi.saveEditSale(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 3.编辑销售合同
    deleteSale ({commit, state}, postData) {
        return new Promise((resolve, reject) => {
            saleApi.deleteSale(postData).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                reject(error);
            })
        })
    }
}
