// 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
// hidden: true // (默认 false)

// 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
// 只有一个时，会将那个子路由当做根路由显示在侧边栏--如引导页面
// 若你想不管路由下面的 children 声明的个数都显示你的根路由
// 你可以设置 alwaysShow: true，这样它就会忽略之前定义的规则，一直显示根路由
// alwaysShow: true

import Vue from 'vue'
import Router from 'vue-router'

/* Router Modules */
// 欢迎
import welcomeRouter from './modules/welcome'
// 车间（设备数据）
import workshopRouter from './modules/workshop'
// 化验室数据
import laboratoryRouter from './modules/laboratory'
// 设备运行时间
import deviceRunningTimeRouter from './modules/deviceRunning'
// 基础数据
import basicRouter from './modules/basic'
// AVI大屏
import monitorRouter from './modules/monitor'
// 监控大屏
import centerControl from './modules/centerControll'
// 系统管理
import systemRouter from './modules/system'

Vue.use(Router)

// 框架级路由
export const constantRouterMap = [{
    path: '/',
    name: 'Login',
    component: () => import('@/views/Login'),
    hidden: true
},
{
    path: '/404',
    component: () => import('@/views/ErrorPage/404'),
    hidden: true
},
{
    path: '/401',
    component: () => import('@/views/ErrorPage/401'),
    hidden: true
},
{
    path: '/led',
    component: () => import('@/views/Layout/lsd'),
    redirect: '/led/stationElectrophoresis',
    meta: { title: 'Led', icon: 'template', openNewWindow: true },
    // hidden: true,
    children: [
        {
            path: 'stationElectrophoresis', //电泳
            component: () => import('@/views/Led/Station/electrophoresis'),
            name: 'StationElectrophoresis',
            meta: { title: 'StationElectrophoresis', icon: 'template' }
        },
        {
            path: 'stationInsulatingAnticorrosive', //隔热防腐
            component: () => import('@/views/Led/Station/insulatingAnticorrosive'),
            name: 'stationInsulatingAnticorrosive',
            meta: { title: 'stationInsulatingAnticorrosive', icon: 'template' }
        },
        {
            path: 'stationPutty', //腻子
            component: () => import('@/views/Led/Station/putty'),
            name: 'StationPutty',
            meta: { title: 'StationPutty', icon: 'template' }
        },
        {
            path: 'stationApplyArtificial', //中涂人工
            component: () => import('@/views/Led/Station/applyArtificial'),
            name: 'StationApplyArtificial',
            meta: { title: 'StationApplyArtificial', icon: 'template' }
        },
        {
            path: 'stationFloatingCoatRobot', //中涂机器人
            component: () => import('@/views/Led/Station/floatingCoatRobot'),
            name: 'StationFloatingCoatRobot',
            meta: { title: 'StationFloatingCoatRobot', icon: 'template' }
        },
        {
            path: 'stationSurfaceVarnish', //面/清漆
            component: () => import('@/views/Led/Station/surfaceVarnish'),
            name: 'StationSurfaceVarnish',
            meta: { title: 'StationSurfaceVarnish', icon: 'template' }
        },
        {
            path: 'stationSprayDryingRoom', //喷漆室，烘干室
            component: () => import('@/views/Led/Station/sprayDryingRoom'),
            name: 'StationSprayDryingRoom',
            meta: { title: 'StationSprayDryingRoom', icon: 'template' }
        },
        {
            path: 'stationPaintingWorkShop', //涂装车间
            component: () => import('@/views/Led/Station/paintingWorkShop'),
            name: 'StationPaintingWorkShop',
            meta: { title: 'StationPaintingWorkShop', icon: 'template' }
        }
    ]
}]

// 业务级路由（后期可能在界面中动态配置）
export const asyncRouterMap = [
    welcomeRouter,
    workshopRouter,
    laboratoryRouter,
    deviceRunningTimeRouter,
    basicRouter,
    monitorRouter,
    centerControl,
    systemRouter,
    {
        path: '*',
        redirect: '/404',
        hidden: true
    }
]

export default new Router({
    // mode: 'history', // require service support
    scrollBehavior: () => ({
        y: 0
    }),
    routes: constantRouterMap
})
