import request from '@/utils/request';

export default {
    // 1.获取公告列表
    getNoticeList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/workbench/getNoticeList`,
            method: 'get',
            data
        })
    },
    // 获取公告列表详情数据
    getNoticeDetail (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/workbench/getNoticeDetail`,
            method: 'get',
            data
        })
    },
    // 获取公报修工单列表数据
    getOrderList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/workbench/getLatestRepairsWorkOrderList`,
            method: 'get',
            data
        })
    },
    // 获取设备列表数据
    getMachineList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/workbench/getEquipmentList`,
            method: 'get',
            data
        })
    },
    // 获取当前登录客户的信息
    getUserList (queryParams) {
        const data = queryParams;
        return request({
            url: `${process.env.API_HOST}/api/v1/user`,
            method: 'get',
            data
        })
    }
}
