import request from '@/utils/request'
export default {
    // 1.获取销售合同列表
    getSaleList (queryParams) {
        return request({
            url: `${process.env.API_HOST}/salesContract/getPageList`,
            method: 'post',
            data: queryParams
        })
    },
    // 2.新增销售合同
    saveAddSale (postData) {
        return request({
            url: `${process.env.API_HOST}/salesContract/create`,
            method: 'post',
            data: postData
        })
    },
    // 3.编辑销售合同
    saveEditSale (postData) {
        return request({
            url: `${process.env.API_HOST}/salesContract/update`,
            method: 'put',
            data: postData
        })
    },
    // 3.编辑销售合同
    deleteSale (postData) {
        return request({
            url: `${process.env.API_HOST}//salesContract/delete`,
            method: 'delete',
            data: postData
        })
    }
}
