import request from '@/utils/request'

export default {
    // 获取所有部门
    getAllDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group/tree`,
            method: 'get',
            data: {}
        })
    },
    // 获取一个部门的子级部门（只获取一层）
    getSubDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group/${param.groupId}/children`,
            method: 'get',
            data: {}
        })
    },
    // 新增一个部门
    addDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group`,
            method: 'post',
            data: {
                code: param.code,
                name: param.name,
                parentId: param.parentId,
                level: param.level,
                responsible: param.responsible
            }
        })
    },
    // 更新一个部门
    updateDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group`,
            method: 'put',
            data: {
                id: param.id,
                code: param.code,
                name: param.name,
                parentId: param.parentId,
                level: param.level,
                responsible: param.responsible
            }
        })
    },
    // 删除一个部门
    deleteDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group/${param.groupId}`,
            method: 'delete',
            data: {
                groupId: param.groupId
            }
        })
    },
    // 给部门调整角色
    adjustDepartmentRole (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/group/role`,
            method: 'post',
            data: {
                override: param.override,
                groupIdList: param.groupIdList,
                roleIdList: param.roleIdList
            }
        })
    },
    // 获取一个部门的成员
    getSubMember (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/page`,
            method: 'get',
            data: {
                groupId: param.groupId,
                like: '',
                num: param.num,
                size: param.size
            }
        })
    },
    // 新增一个成员
    addMember (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user`,
            method: 'post',
            data: {
                enabled: true,
                username: param.username,
                name: param.name,
                groupId: param.groupId,
                post: param.post,
                no: param.no,
                contact: param.contact,
                email: param.email,
                password: param.password,
                leader: param.leader,
                authorities: [],
                photoUrl: param.photoUrl
            }
        })
    },
    // 更新一个成员
    updateMember (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/userInfo`,
            method: 'put',
            data: {
                id: param.id,
                enabled: param.enabled,
                username: param.username,
                name: param.name,
                groupId: param.groupId,
                post: param.post,
                no: param.no,
                contact: param.contact,
                email: param.email,
                password: param.password,
                leader: param.leader,
                authorities: param.authorities,
                photoUrl: param.photoUrl
            }
        })
    },
    // 删除成员
    deleteMember (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/single/${param}`,
            method: 'delete',
            data: {}
        })
    },
    // 重置成员密码
    resetMemberPassword (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/${param.id}/reset/password`,
            method: 'put',
            data: {
                id: param.id,
                enabled: param.enabled,
                username: param.username,
                name: param.name,
                groupId: param.groupId,
                post: param.post,
                no: param.no,
                contact: param.contact,
                email: param.email,
                password: param.password,
                leader: param.leader,
                authorities: param.authorities,
                photoUrl: param.photoUrl
            }
        })
    },
    // 给成员调整部门
    adjustMemberDepartment (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/group`,
            method: 'post',
            data: {
                override: param.override,
                groupIdList: param.groupIdList,
                userIdList: param.userIdList
            }
        })
    },
    // 给成员调整角色
    adjustMemberRole (param) {
        return request({
            url: `${process.env.API_HOST}/api/v1/user/role`,
            method: 'post',
            data: {
                override: param.override,
                userIdList: param.userIdList,
                roleIdList: param.roleIdList
            }
        })
    }
}
