import request from '@/utils/request'

export default {
    /*---------------------------------------工单管理-------------------------------------*/
    // 获取工单列表
    getOrderList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workOrder/page`,
            method: 'get',
            data
        })
    },
    // 新增工单
    addOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workOrder/createWorkOrder`,
            method: 'post',
            data
        })
    },
    // 编辑工单
    updateOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workOrder/updateworkOrderInfo`,
            method: 'put',
            data
        })
    },
    // 删除工单
    deleteOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workOrder/deleteWorkOrderByCode/${param}`,
            method: 'delete',
            data
        })
    },
    // 获取流转单列表数据
    getFlowOrderList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workOrder/findExecuteById`,
            method: 'get',
            data
        })
    },
    // 新增流转单
    addFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/createWorkExecute`,
            method: 'post',
            data
        })
    },
    // 编辑流转单
    updateFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/updateworkExeCuteInfo`,
            method: 'put',
            data
        })
    },
    // 删除流转单
    deleteFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/deleteWorkExecuteById`,
            method: 'delete',
            data
        })
    },
    // 批量派发流转单
    batchDistributedFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/isWorkExecute`,
            method: 'post',
            data
        })
    },
    // 批量打印流转单
    batchPrintFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/printWorkExecute`,
            method: 'post',
            data
        })
    },
    // 打印流转单
    printFlowOrder (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/printExecute`,
            method: 'post',
            data
        })
    },
    // 查询打印机和模板列表数据
    getPrintTemplateList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/findPrinterInfo`,
            method: 'get',
            data
        })
    },
    // 工序记录列表数据
    getProcessRecordList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/getProcessByExecode`,
            method: 'get',
            data
        })
    },
    // 工步记录列表数据
    getStepRecordList (param) {
        const data = param;
        return request({
            url: `${process.env.API_HOST}/api/workExecuteInfo/getProcessStepByExecode`,
            method: 'get',
            data
        })
    },
    /*-----------------------------------------------数据文件-----------------------------*/
    // 获取数据文件列表数据
    getDataFileList (param) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = param;
        // API_SCADA
        return request({
            url: `${url}/api/testDataFile/page`,
            method: 'get',
            data
        })
    },
    // 获取数据文件列表数据 精准搜索
    getDataFilePageList (param) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = param;
        // API_SCADA
        return request({
            url: `${url}/api/testDataFile/findPage`,
            method: 'post',
            data
        })
    },
    // 下载数据文件
    downloadDataFile (param) {
        let scadaUrl = window.sessionStorage.getItem('Admin-scadaUrl');
        let url = JSON.parse(scadaUrl).baseUrl;
        const data = param;
        return request({
            url: `${url}/api/testDataFile/download/${param.id}`,
            method: 'get',
            data
        })
    }
}
