import templateApi from '@/api/template';

// actions
export default {
    // 1.获取检修、保养模板列表数据
    getTemplateListData ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            templateApi.getTemplateListData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 2.获取检修模板列表
    getRepairTemplateListData ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            templateApi.getRepairTemplateListData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 3.获取保养模板列表
    getMaintainTemplateListData ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            templateApi.getMaintainTemplateListData(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 4.新增模板
    templateCreate ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            templateApi.templateCreate(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    },
    // 5.编辑模板
    templateEdit ({dispatch, commit, state, rootState}, queryParams) {
        return new Promise((resolve, reject) => {
            templateApi.templateEdit(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    reject(response)
                }
            }).catch((e) => {
                reject(e)
            })
        });
    }
};

