import API from '@/api/productionLine'
import {Message} from 'element-ui'

export default {
    /*---------------------------------设备分类数据-----------------------------------*/
    // 获取产线下面的工位
    getStationList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getStationList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 获取产线列表数据
    getProductionLineList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.getProductionLineList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 新增产线
    addProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.addProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 编辑产线
    updateProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.updateProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 删除产线
    deleteProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.deleteProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 根据产线ID请求产线详情
    findById ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.findById(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    },
    // 启用产线
    enableProductionLine ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            API.enableProductionLine(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data)
                } else {
                    Message.error(response.message);
                    reject(response);
                }
            }).catch(error => {
                Message.error(error);
                reject(error)
            })
        });
    }
}
