import gatewayApi from '@/api/gateway'
import {Message} from 'element-ui'
export default {
    // 1.获取网关档案列表
    getGatewayList ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            gatewayApi.getGatewayList(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    reject(response);
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 2.网关档案新建
    gatewayCreate ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            gatewayApi.gatewayCreate(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    reject(response);
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 3.网关档案编辑
    gatewayEdit ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            gatewayApi.gatewayEdit(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    reject(response);
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error);
            })
        })
    },
    // 4.网关档案删除
    gatewayDelete ({commit, state}, queryParams) {
        return new Promise((resolve, reject) => {
            gatewayApi.gatewayDelete(queryParams).then(response => {
                if (response.code === 600) {
                    resolve(response.data);
                } else {
                    reject(response);
                    Message.error(response.message);
                }
            }).catch(error => {
                reject(error);
            })
        })
    }
}
